CREATE OR REPLACE PACKAGE TBICDS.PCK_XFER
AUTHID CURRENT_USER 
IS

/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/ 
--custom to return recordsets
type RetRefCursor is ref cursor;
type refCursor is ref cursor;


/*transfer a patient admission to the central database*/
procedure XferPatientVisit(
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nXferSystemID          in number,
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_vDFN                   in varchar2,
      
      pi_vVisitID               in number,
      pi_nVisitLocationID       in number,
      pi_vVisitLocationName     in varchar2,
      pi_vVisitTimeStamp        in varchar2,
      pi_vVisitStatus           in varchar2,           
      pi_vVisitType             in varchar2,               
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2);
      
/*transfer a patient admission to the central database*/
procedure XferPatientAdmission(
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nXferSystemID          in number,
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_vDFN                   in varchar2,
      
      pi_nAdmitLocationID       in number,
      pi_vAdmitLocationName     in varchar2,
      pi_vAdmitType             in varchar2,
      pi_vAdmitTimeStamp        in varchar2,
      pi_vDischargeTimeStamp   in varchar2,                          
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2);
      
/*transfers a patient consult to the central database*/
procedure XferPatientConsult(
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nXferSystemID          in number,
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_vDFN                   in varchar2,
      
      pi_vConsultID             in varchar2,
      pi_vConsultTimeStamp      in varchar2,
      pi_vConsultStatus         in varchar2,
      pi_vConsultTitle          in varchar2,
      pi_vConsultText           in varchar2,                          
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2);
      

/*transfers a patient appointment to the database*/
procedure XferPatientAppointment(
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nXferSystemID          in number,
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_vAppointmentID         in varchar2,
      pi_vDFN                   in varchar2,
      pi_nApptClinicID          in number,
      pi_nApptSiteID            in number,
      pi_vApptCurrentStatus     in varchar2,
      pi_vApptPurpose           in varchar2,
      pi_vApptStatus            in varchar2,
      pi_vApptText              in varchar2,
      pi_vApptTimeStamp         in varchar2,
      pi_vApptTitle             in varchar2,
      pi_vApptType              in varchar2,
      pi_vApptVisitID           in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2);
      
/*
transfers a clinic to the database
*/
procedure XferClinic(
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nXferSystemID          in number,
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_nClinicID              in number,
      pi_vClinicLabel           in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2);
      
/*Transfers a note title from an external source such as MDWS to the database
*/
procedure XferNoteTitle(
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nXferSystemID          in number,
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_nNoteTitleTag          in number,
      pi_vNoteTitleLabel        in varchar2,
      pi_nIsConsult             in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2);
        
/*
saves a region to the database
*/
procedure XferRegion(
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nXferSystemID          in number,
      pi_nRegionID              in number,
      pi_vRegionName            in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2);


/*
saves a site to the database
*/
procedure XferSite(
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nXferSystemID          in number,
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_vSiteName            in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2);
      
/*
saves a user to the database
*/
procedure XferUser(
      pi_vSessionID           in varchar2,
      pi_vSessionClientIP     in varchar2,
      pi_nUserID              in number,
      pi_nXferSystemID        in number,
      pi_vDUZ                 in varchar2,
      pi_vLastName            in varchar2,
      pi_vFirstName           in varchar2,
      pi_vFirstLastName       in varchar2, 
      pi_vGreeting            in varchar2,
      pi_vTitle               in varchar2,
      pi_nRegionID            in number,
      pi_nSiteID              in number,
      pi_vUserClass           in varchar2,
      po_nUserID              out number,
      po_nStatusCode          out number,
      po_vStatusComment       out varchar2);

/*
saves a patient to the database
*/      
procedure XferPatient (   pi_vSessionID        in varchar2,
                          pi_vSessionClientIP  in varchar2,
                          pi_nUserID           in number,
                          pi_nXferSystemID     in number,
                          pi_vKey              in varchar2,
                          pi_nRegionID         in number,
                          pi_nSiteID           in number,
                          pi_vMDWSPatientID              in varchar2,
                          pi_vSSN              in varchar2,
                          pi_dtDOB             in date,
                          pi_vFirstName        in varchar2,
                          pi_vFullName         in varchar2,
                          pi_vLastName         in varchar2,
                          pi_vMI               in varchar2,
                          pi_nSex              in number,
                          pi_vHomeAddr1        in varchar2,
                          pi_vHomeAddr2        in varchar2,
                          pi_vHomeCity         in varchar2,
                          pi_vHomeState        in varchar2,
                          pi_vHomeZip          in varchar2,
                          pi_vHomePhone        in varchar2,
                          po_vPatientID        out varchar2,
                          po_nStatusCode       out number,
                          po_vStatusComment    out varchar2
                       );      


END;
/

